/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.MRFHeader;
import com.elluminate.mediastream.MRFImageData;
import com.elluminate.mediastream.MRFPacket;
import com.elluminate.mediastream.MRFile;
import com.elluminate.mediastream.PacketListener;
import com.elluminate.mediastream.imageprocessing.ImageUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class TestImage
extends JFrame {
    private static DateFormat dateFormatter = DateFormat.getDateTimeInstance();
    private long baseTime;
    private JButton browseButton = new JButton();
    private JPanel contentPane;
    private JPanel controlPanel = new JPanel();
    private DisplayPanel displayPanel = new DisplayPanel();
    private JFileChooser mrfChooser = null;
    private MRFile mrFile;
    private JTextField pathField = new JTextField();
    private JLabel pathLabel = new JLabel();

    public TestImage() {
        try {
            this.setDefaultCloseOperation(3);
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.setSize(new Dimension(400, 300));
        this.setTitle("Image Display");
        this.browseButton.setText("Browse MRF...");
        this.pathLabel.setText("MRF Path:");
        this.controlPanel.setLayout(new GridBagLayout());
        this.contentPane.add((Component)this.controlPanel, "North");
        this.controlPanel.add((Component)this.pathField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.controlPanel.add((Component)this.browseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.controlPanel.add((Component)this.pathLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.contentPane.add((Component)this.displayPanel, "Center");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestImage.this.browseMRF();
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private void browseMRF() {
        int type;
        if (this.mrfChooser == null) {
            this.mrfChooser = new JFileChooser();
            this.mrfChooser.setAcceptAllFileFilterUsed(false);
            this.mrfChooser.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase(Locale.ENGLISH).endsWith(".mrf");
                }

                public String getDescription() {
                    return "MRF file filter";
                }
            });
        }
        if ((type = this.mrfChooser.showOpenDialog(this)) == 0) {
            this.mrFile = new MRFile(this.mrfChooser.getSelectedFile());
            this.pathField.setText(this.mrfChooser.getSelectedFile().getPath());
            this.mrFile.addPacketListener(new PacketListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onMRFPacket(MRFPacket packet) {
                    switch (packet.getPacketType()) {
                        case 1: {
                            MRFHeader header = (MRFHeader)packet;
                            TestImage.this.baseTime = System.currentTimeMillis() - header.getTime();
                            TestImage.this.setTitle("MRF Test - " + header.getRecordingName() + TestImage.formatDate(header.getTime()));
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 6: {
                            MRFImageData data = (MRFImageData)packet;
                            if (data.getTime() > System.currentTimeMillis() - TestImage.this.baseTime) {
                                3 var4_4 = this;
                                synchronized (var4_4) {
                                    long time = data.getTime() - System.currentTimeMillis() - TestImage.this.baseTime;
                                    try {
                                        this.wait(5000L);
                                    }
                                    catch (InterruptedException ex) {
                                        // empty catch block
                                    }
                                }
                            }
                            TestImage.this.displayPanel.setTile(data.getTileNumber(), data.getTileImage());
                            break;
                        }
                    }
                }
            });
            Thread fileProcess = new Thread(new Runnable(){

                public void run() {
                    try {
                        TestImage.this.mrFile.processFile();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }, "MRF File Processing Thread");
            fileProcess.setDaemon(true);
            fileProcess.start();
        }
    }

    public static String formatDate(long time) {
        return dateFormatter.format(new Date(time));
    }

    public static void main(String[] args) {
        TestImage test = new TestImage();
        test.setVisible(true);
    }

    class DisplayPanel
    extends JPanel {
        private BufferedImage image = new BufferedImage(320, 240, 2);
        private Graphics2D graphics = this.image.createGraphics();

        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage((Image)this.image, 0, 0, null);
        }

        public void setTile(short tileNumber, Image tileImage) {
            Point loc = ImageUtilities.getPixelFloorFromTileNumber((int)tileNumber);
            this.graphics.drawImage(tileImage, loc.x, loc.y, null);
            this.repaint(loc.x, loc.y, 16, 16);
        }
    }
}

