/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.FeedPacket;
import com.elluminate.mediastream.MRFPacket;
import com.elluminate.mediastream.TimedPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFShow
extends MRFPacket
implements FeedPacket,
TimedPacket {
    private short feedIdx;
    private boolean visible;
    private long time;

    public MRFShow(short feedIdx, boolean visible, long time) {
        super((byte)8);
        this.feedIdx = feedIdx;
        this.visible = visible;
        this.time = time;
    }

    public MRFShow(byte[] packetData) throws IOException {
        super((byte)8);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.feedIdx = istr.readShort();
        this.visible = istr.readBoolean();
        this.time = istr.readLong();
    }

    public short getFeedIdx() {
        return this.feedIdx;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setFeedIdx(short feedIdx) {
        this.feedIdx = feedIdx;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeShort(this.feedIdx);
        ostr.writeBoolean(this.visible);
        ostr.writeLong(this.time);
        return bostr.toByteArray();
    }

    public String toString() {
        return "MRFShow: " + this.feedIdx + ", visible: " + this.visible + ", time: " + MRFShow.decodeTime(this.time);
    }
}

