/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.MRFPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFConditionFeed
extends MRFPacket {
    private short feedIndex;
    private byte[] data;

    public MRFConditionFeed(short feedIndex, byte[] data) {
        super((byte)16);
        this.feedIndex = feedIndex;
        this.setConditionData(data);
    }

    public MRFConditionFeed(byte[] packetData) throws IOException {
        super((byte)16);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.feedIndex = istr.readShort();
        this.data = new byte[istr.available()];
        istr.read(this.data);
    }

    public short getFeedIndex() {
        return this.feedIndex;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setFeedIndex(short feedIndex) {
        this.feedIndex = feedIndex;
    }

    public void setConditionData(byte[] data) {
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeShort(this.feedIndex);
        ostr.write(this.data);
        return bostr.toByteArray();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("MRFConditionFeed: " + this.feedIndex + ": ");
        for (int i = 0; i < this.data.length; ++i) {
            buf.append(Integer.toHexString(this.data[i]));
            if (i + 1 >= this.data.length) continue;
            buf.append(", ");
        }
        return buf.toString();
    }
}

