/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.MRFPacket;
import com.elluminate.mediastream.TimedPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFClient
extends MRFPacket
implements TimedPacket {
    private boolean online = false;
    private short clientAddress;
    private short clientGroup;
    private String clientName;
    private String displayName;
    private long time;

    public MRFClient(String clientName, short clientAddress, String displayName, short clientGroup, boolean online, long time) {
        super((byte)9);
        this.clientName = clientName;
        this.clientAddress = clientAddress;
        this.displayName = displayName;
        this.clientGroup = clientGroup;
        this.online = online;
        this.time = time;
    }

    public MRFClient(byte[] packetData) throws IOException {
        super((byte)9);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.clientName = istr.readUTF();
        this.clientAddress = istr.readShort();
        this.displayName = istr.readUTF();
        this.clientGroup = istr.readShort();
        this.online = istr.readBoolean();
        this.time = istr.readLong();
    }

    public short getClientAddress() {
        return this.clientAddress;
    }

    public short getClientGroup() {
        return this.clientGroup;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public void setClientAddress(short clientAddress) {
        this.clientAddress = clientAddress;
    }

    public void setClientGroup(short clientGroup) {
        this.clientGroup = clientGroup;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        if (this.clientName == null) {
            ostr.writeUTF("");
        } else {
            ostr.writeUTF(this.clientName);
        }
        ostr.writeShort(this.clientAddress);
        if (this.displayName == null) {
            ostr.writeUTF("");
        } else {
            ostr.writeUTF(this.displayName);
        }
        ostr.writeShort(this.clientGroup);
        ostr.writeBoolean(this.online);
        ostr.writeLong(this.time);
        return bostr.toByteArray();
    }

    public String toString() {
        return "MRFClient: " + this.clientName + ", address: " + this.clientAddress + ", displayName: " + this.displayName + ", group: " + this.clientGroup + ", online: " + this.online + ", time: " + MRFClient.decodeTime(this.time);
    }
}

