/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.MRFAudioControl;
import com.elluminate.mediastream.MRFAudioData;
import com.elluminate.mediastream.MRFClient;
import com.elluminate.mediastream.MRFConditionFeed;
import com.elluminate.mediastream.MRFDuplicateTiles;
import com.elluminate.mediastream.MRFFeed;
import com.elluminate.mediastream.MRFGroup;
import com.elluminate.mediastream.MRFHeader;
import com.elluminate.mediastream.MRFImageControl;
import com.elluminate.mediastream.MRFImageData;
import com.elluminate.mediastream.MRFIndexMark;
import com.elluminate.mediastream.MRFModule;
import com.elluminate.mediastream.MRFRecordingControl;
import com.elluminate.mediastream.MRFSessionName;
import com.elluminate.mediastream.MRFShow;
import com.elluminate.mediastream.MRFTextData;
import com.elluminate.mediastream.MRFUnknown;
import com.elluminate.mediastream.MRFile;
import com.elluminate.mediastream.TimedPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public abstract class MRFPacket {
    public static final boolean PACKET_DEBUG = System.getProperty("packetdebug", null) != null;
    public static final byte MRF_UNKNOWN = 0;
    public static final byte MRF_HEADER = 1;
    public static final byte MRF_MODULE = 2;
    public static final byte MRF_FEED = 3;
    public static final byte MRF_AUDIO_CONTROL = 4;
    public static final byte MRF_AUDIO_DATA = 5;
    public static final byte MRF_IMAGE_DATA = 6;
    public static final byte MRF_TEXT_DATA = 7;
    public static final byte MRF_SHOW = 8;
    public static final byte MRF_CLIENT = 9;
    public static final byte MRF_IMAGE_CONTROL = 10;
    public static final byte MRF_GROUP = 11;
    public static final byte MRF_DUPLICATE_TILES = 12;
    public static final byte MRF_SESSION_NAME = 13;
    public static final byte MRF_INDEX_MARK = 14;
    public static final byte MRF_RECORDING_CONTROL = 15;
    public static final byte MRF_CONDITION_FEED = 16;
    public static final String[] MRF_PACKET_TYPES = new String[]{"MRF_UNKNOWN", "MRF_HEADER", "MRF_MODULE", "MRF_FEED", "MRF_AUDIO_CONTROL", "MRF_AUDIO_DATA", "MRF_IMAGE_DATA", "MRF_TEXT_DATA", "MRF_SHOW", "MRF_CLIENT", "MRF_IMAGE_CONTROL", "MRF_GROUP", "MRF_DUPLICATE_TILES", "MRF_SESSION_NAME", "MRF_INDEX_MARK", "MRF_RECORDING_CONTROL", "MRF_CONDITION_FEED"};
    public static final byte IMAGE_FEED = 0;
    public static final byte AUDIO_FEED = 1;
    public static final byte TEXT_IO_FEED = 2;
    public static final byte TEXT_O_FEED = 3;
    public static final byte PARTICIPANT_FEED = 4;
    public static final String[] FEED_NAMES = new String[]{"Image", "Audio", "Text", "Participant"};
    public static final int MRF_VERSION_MAJOR = 1;
    public static final int MRF_VERSION_MINOR = 1;
    public static final short NO_AUTHOR = -1;
    private int packetSize = 0;
    private byte packetType;

    MRFPacket(byte packetType) {
        if (packetType < 0 || packetType > MRF_PACKET_TYPES.length) {
            throw new RuntimeException("Packet Type out-of-range: " + packetType);
        }
        this.packetType = packetType;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public byte getPacketType() {
        if (this.packetType < 0 || this.packetType > MRF_PACKET_TYPES.length) {
            throw new RuntimeException("Packet Type out-of-range: " + this.packetType);
        }
        return this.packetType;
    }

    public abstract byte[] toByteArray() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MRFPacket readPacket(MRFile recording) throws IOException {
        MRFPacket result;
        short len = 0;
        byte type = 0;
        byte[] packetBytes = null;
        MRFile mRFile = recording;
        synchronized (mRFile) {
            try {
                DataInputStream istr = recording.getInputStream();
                if (istr == null) {
                    return null;
                }
                long fileOffset = recording.getFileOffset();
                len = istr.readShort();
                if (len < 0) {
                    throw new IOException("Damaged MRF File - negative packet length.");
                }
                type = istr.readByte();
                packetBytes = new byte[len];
                int read = 0;
                int offset = 0;
                while (read >= 0 && offset < packetBytes.length) {
                    read = istr.read(packetBytes, offset, packetBytes.length - offset);
                    if (read <= 0) continue;
                    offset += read;
                }
            }
            catch (EOFException ex) {
                return null;
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
            recording.incrementFileOffset(3 + len);
        }
        if (PACKET_DEBUG) {
            try {
                System.out.println("MRFPacket.readPacket: " + recording.getFileOffset() + ", " + MRF_PACKET_TYPES[type]);
            }
            catch (Exception ex1) {
                System.out.println("MRFPacket.readPacket - invalid type: " + recording.getFileOffset() + ", " + type);
            }
        }
        switch (type) {
            default: {
                result = new MRFUnknown(type, packetBytes);
                break;
            }
            case 1: {
                result = new MRFHeader(packetBytes);
                break;
            }
            case 2: {
                result = new MRFModule(packetBytes);
                break;
            }
            case 3: {
                result = new MRFFeed(packetBytes);
                break;
            }
            case 4: {
                result = new MRFAudioControl(packetBytes);
                break;
            }
            case 5: {
                result = new MRFAudioData(packetBytes);
                break;
            }
            case 6: {
                result = new MRFImageData(packetBytes);
                break;
            }
            case 7: {
                result = new MRFTextData(packetBytes);
                break;
            }
            case 8: {
                result = new MRFShow(packetBytes);
                break;
            }
            case 9: {
                result = new MRFClient(packetBytes);
                break;
            }
            case 10: {
                result = new MRFImageControl(packetBytes);
                break;
            }
            case 11: {
                result = new MRFGroup(packetBytes);
                break;
            }
            case 12: {
                result = new MRFDuplicateTiles(packetBytes);
                break;
            }
            case 13: {
                result = new MRFSessionName(packetBytes);
                break;
            }
            case 14: {
                result = new MRFIndexMark(packetBytes);
                break;
            }
            case 15: {
                result = new MRFRecordingControl(packetBytes);
                break;
            }
            case 16: {
                result = new MRFConditionFeed(packetBytes);
            }
        }
        result.packetSize = packetBytes.length;
        if (PACKET_DEBUG) {
            System.out.print("MRFPacket.readPacket: " + result.toString());
            if (result instanceof TimedPacket) {
                long time = ((TimedPacket)((Object)result)).getTime();
                System.out.println(", time: " + time);
            } else {
                System.out.println();
            }
        }
        return result;
    }

    public static String decodeTime(long milliseconds) {
        String seconds;
        String hours = "" + milliseconds / 3600000L;
        String minutes = "" + milliseconds / 60000L % 60L;
        if (minutes.length() == 1) {
            minutes = "0" + minutes;
        }
        if ((seconds = "" + milliseconds / 1000L % 60L).length() == 1) {
            seconds = "0" + seconds;
        }
        if (hours.equals("0")) {
            return minutes + ":" + seconds + "." + milliseconds % 1000L;
        }
        return hours + ":" + minutes + ":" + seconds + "." + milliseconds % 1000L;
    }

    public abstract String toString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writePacket(MRFPacket packet, MRFile recording) throws IOException {
        if (PACKET_DEBUG) {
            try {
                System.out.println("MRFPacket.writePacket: " + recording.getFileOffset() + ", " + MRF_PACKET_TYPES[packet.getPacketType()]);
            }
            catch (Exception ex1) {
                System.out.println("MRFPacket.writePacket - invalid type: " + recording.getFileOffset() + ", " + packet.getPacketType());
            }
        }
        MRFile mRFile = recording;
        synchronized (mRFile) {
            byte[] bytes = packet.toByteArray();
            DataOutputStream ostr = recording.getOutputStream();
            if (ostr != null) {
                ostr.writeShort(bytes.length);
                ostr.writeByte(packet.getPacketType());
                ostr.write(bytes);
            }
        }
    }

    void writePacket(MRFile recording) throws IOException {
        MRFPacket.writePacket(this, recording);
    }
}

