/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.FeedPacket;
import com.elluminate.mediastream.MRFPacket;
import com.elluminate.mediastream.TimedPacket;
import com.elluminate.mediastream.imageprocessing.ImageUtilities;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFImageData
extends MRFPacket
implements FeedPacket,
TimedPacket {
    private byte[] compressedImageData;
    private short feedIdx;
    private short tileNumber;
    private long time;

    public MRFImageData(short feedIdx, short tileNumber, byte[] compressedImageData, long time) {
        super((byte)6);
        this.feedIdx = feedIdx;
        this.compressedImageData = compressedImageData;
        this.tileNumber = tileNumber;
        this.time = time;
    }

    public MRFImageData(byte[] packetData) throws IOException {
        super((byte)6);
        int offset = 0;
        int read = 0;
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.feedIdx = istr.readShort();
        this.time = istr.readLong();
        this.tileNumber = istr.readShort();
        this.compressedImageData = new byte[istr.available()];
        do {
            read = istr.read(this.compressedImageData, offset, this.compressedImageData.length - offset);
            offset += read;
        } while (read >= 0);
    }

    public byte[] getCompressedImageData() {
        return this.compressedImageData;
    }

    public short getFeedIdx() {
        return this.feedIdx;
    }

    public Image getTileImage() {
        return ImageUtilities.getImageForTile((byte[])this.compressedImageData);
    }

    public short getTileNumber() {
        return this.tileNumber;
    }

    public void setCompressedImageData(byte[] compressedImageData) {
        this.compressedImageData = compressedImageData;
    }

    public long getTime() {
        return this.time;
    }

    public void setFeedIdx(short feedIdx) {
        this.feedIdx = feedIdx;
    }

    public void setTileNumber(short tileNumber) {
        this.tileNumber = tileNumber;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeShort(this.feedIdx);
        ostr.writeLong(this.time);
        ostr.writeShort(this.tileNumber);
        ostr.write(this.compressedImageData);
        return bostr.toByteArray();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("MRFImageData: " + this.feedIdx + ", tileNumber: " + this.tileNumber + ", time: " + MRFImageData.decodeTime(this.time));
        return buf.toString();
    }
}

