/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.FeedPacket;
import com.elluminate.mediastream.MRFPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFFeed
extends MRFPacket
implements FeedPacket {
    public static final String APP_SHARE = "App Share";
    public static final String AUDIO = "Audio";
    public static final String CAPTION = "Caption";
    public static final String CHAT = "Chat";
    public static final String VIDEO = "Video";
    public static final String WHITEBOARD = "Whiteboard";
    private static short FEED_SEQUENCE = 0;
    private short feedIdx;
    private String feedName;
    private byte feedType;
    private short moduleIdx;
    private String protocol;
    private boolean visible = true;

    public MRFFeed(String feedName, short feedIdx, short moduleIdx, byte feedType) {
        super((byte)3);
        this.feedName = MRFFeed.getFeedsName(feedName);
        this.protocol = MRFFeed.getFeedsProtocol(feedName);
        this.moduleIdx = moduleIdx;
        this.feedIdx = feedIdx;
        this.feedType = feedType;
    }

    public MRFFeed(byte[] packetData) throws IOException {
        super((byte)3);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.moduleIdx = istr.readShort();
        this.feedIdx = istr.readShort();
        this.feedType = istr.readByte();
        String name = istr.readUTF();
        this.protocol = MRFFeed.getFeedsProtocol(name);
        this.feedName = MRFFeed.getFeedsName(name);
    }

    public short getFeedIdx() {
        return this.feedIdx;
    }

    public short getModuleIdx() {
        return this.moduleIdx;
    }

    public String getFeedName() {
        return this.feedName;
    }

    public static String getFeedsName(String name) {
        int hash = name.indexOf("#");
        if (hash < 0) {
            return name;
        }
        return name.substring(0, hash);
    }

    public static String getFeedsProtocol(String name) {
        int hash = name.indexOf("#");
        if (hash < 0) {
            return "";
        }
        return name.substring(hash + 1);
    }

    public byte getFeedType() {
        return this.feedType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public static void reset() {
        FEED_SEQUENCE = 0;
    }

    public void setFeedIdx(short feedIdx) {
        this.feedIdx = feedIdx;
    }

    public void setFeedName(String feedName) {
        this.feedName = feedName;
    }

    public void setFeedProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setFeedType(byte feedType) {
        this.feedType = feedType;
    }

    public void setModuleIdx(short moduleIdx) {
        this.moduleIdx = moduleIdx;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeShort(this.moduleIdx);
        ostr.writeShort(this.feedIdx);
        ostr.writeByte(this.feedType);
        String name = this.protocol != null && this.protocol.length() > 0 ? this.feedName + "#" + this.protocol : this.feedName;
        ostr.writeUTF(name);
        return bostr.toByteArray();
    }

    public String toString() {
        return "MRFFeed: " + this.feedName + ", idx: " + this.feedIdx + ", module: " + this.moduleIdx + ", type: " + this.feedType + ", visible: " + this.visible;
    }
}

