/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.FeedPacket;
import com.elluminate.mediastream.MRFPacket;
import com.elluminate.mediastream.TimedPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFAudioData
extends MRFPacket
implements FeedPacket,
TimedPacket {
    private byte[] ecelpPacket;
    private short feedIdx;
    private short talkerAddress;
    private long time;

    public MRFAudioData(short feedIdx, byte[] ecelpPacket, short talkerAddress, long time) {
        super((byte)5);
        this.feedIdx = feedIdx;
        this.ecelpPacket = ecelpPacket;
        this.talkerAddress = talkerAddress;
        this.time = time;
    }

    public MRFAudioData(byte[] packetData) throws IOException {
        super((byte)5);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.feedIdx = istr.readShort();
        this.time = istr.readLong();
        this.talkerAddress = istr.readShort();
        short length = istr.readShort();
        if (length > 0) {
            this.ecelpPacket = new byte[length];
            istr.read(this.ecelpPacket);
        } else {
            this.ecelpPacket = new byte[0];
        }
    }

    public byte[] getEcelpData() {
        return this.ecelpPacket;
    }

    public short getFeedIdx() {
        return this.feedIdx;
    }

    public short getTalkerAddress() {
        return this.talkerAddress;
    }

    public long getTime() {
        return this.time;
    }

    public void setEcelpData(byte[] ecelpPacket) {
        this.ecelpPacket = ecelpPacket;
    }

    public void setFeedIdx(short feedIdx) {
        this.feedIdx = feedIdx;
    }

    public void setTalkerAddress(short talkerAddress) {
        this.talkerAddress = talkerAddress;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeShort(this.feedIdx);
        ostr.writeLong(this.time);
        ostr.writeShort(this.talkerAddress);
        if (this.ecelpPacket == null) {
            ostr.writeShort(0);
        } else {
            ostr.writeShort(this.ecelpPacket.length);
            ostr.write(this.ecelpPacket);
        }
        return bostr.toByteArray();
    }

    public String toString() {
        return "MRFAudioData: " + this.feedIdx + ", bytes: " + this.ecelpPacket.length + ", talker: " + this.talkerAddress + ", time: " + MRFAudioData.decodeTime(this.time);
    }
}

