/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.common;

import java.net.MalformedURLException;
import java.net.URL;

public class URLString {
    String proto = "http";
    String host = "localhost";
    int port = -1;
    String path = null;

    public URLString() {
    }

    public URLString(String str) throws MalformedURLException {
        try {
            String tmpPath;
            String tmpPort;
            String tmpHost;
            int separator = str.indexOf("://");
            if (separator < 0) {
                throw new MalformedURLException("No protocol specified in URL '" + str + "'");
            }
            String tmpProto = str.substring(0, separator).toLowerCase();
            int colon = str.indexOf(58, separator += 3);
            int slash = str.indexOf(47, separator);
            if (colon < 0 && slash < 0) {
                tmpHost = str.substring(separator).trim();
                tmpPort = null;
                tmpPath = null;
            } else if (colon < 0) {
                tmpHost = str.substring(separator, slash).trim();
                tmpPort = null;
                tmpPath = str.substring(slash).trim();
            } else if (slash < 0) {
                tmpHost = str.substring(separator, colon).trim();
                tmpPort = str.substring(colon + 1).trim();
                tmpPath = null;
            } else if (slash < colon) {
                tmpHost = str.substring(separator, slash).trim();
                tmpPath = str.substring(slash).trim();
                tmpPort = null;
            } else {
                tmpHost = str.substring(separator, colon).trim();
                tmpPort = str.substring(colon + 1, slash).trim();
                tmpPath = str.substring(slash).trim();
            }
            if (tmpHost.equals("") && !tmpProto.equals("file")) {
                throw new MalformedURLException("Empty host name not allowed '" + str + "'");
            }
            if (tmpPort != null && tmpPort.equals("") && !tmpProto.equals("file")) {
                throw new MalformedURLException("Empty port specification not allowed '" + str + "'");
            }
            if (tmpPort != null) {
                this.port = Integer.parseInt(tmpPort);
                if (this.port < 1 || this.port > 65535) {
                    throw new MalformedURLException("Port '" + this.port + "' out of range 1-65535");
                }
            }
            this.host = tmpHost;
            this.proto = tmpProto;
            this.path = tmpPath;
        }
        catch (MalformedURLException ex) {
            throw ex;
        }
        catch (Exception ex2) {
            throw new MalformedURLException("Exception while parsing URL '" + str + "'\n  " + ex2.toString());
        }
    }

    public URLString(URL url) {
        this.setProtocol(url.getProtocol());
        this.setHost(url.getHost());
        this.setPort(url.getPort());
        this.setPath(url.getPath());
    }

    public URLString(String proto, String host, int port, String path) {
        this.setProtocol(proto);
        this.setHost(host);
        this.setPort(port);
        this.setPath(path);
    }

    public void setProtocol(String proto) {
        this.proto = proto.toLowerCase();
    }

    public String getProtocol() {
        return this.proto;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setPath(String path) {
        this.path = path != null ? (path.length() == 0 ? "/" : (path.charAt(0) == '/' ? path : "/" + path)) : null;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        if (this.path == null) {
            return null;
        }
        if (this.path.length() < 2) {
            return null;
        }
        return this.path.substring(1);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.proto);
        buf.append("://");
        buf.append(this.host);
        if (this.port > 0) {
            buf.append(":");
            buf.append(this.port);
        }
        if (this.path != null) {
            buf.append(this.path);
        }
        return buf.toString();
    }
}

