/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.builders;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class Splash
extends JFrame {
    private JLabel actionLabel = new JLabel();
    private JProgressBar progress = new JProgressBar();
    private JLabel splashImage = new JLabel();
    private JPanel splashPanel = new JPanel(new BorderLayout());

    public Splash(String title, String imageText, String labelText, ImageIcon suppliedIcon) {
        this.setUndecorated(true);
        this.setTitle(title);
        this.splashPanel.setBorder(new LineBorder(Color.black, 2));
        this.setContentPane(this.splashPanel);
        this.splashPanel.setOpaque(true);
        this.splashPanel.setBackground(Color.white);
        ImageIcon icon = suppliedIcon;
        try {
            if (icon == null) {
                URL url = this.getClass().getResource("images/Splash.png");
                icon = new ImageIcon(url);
            }
            this.splashImage.setIcon(icon);
            this.splashImage.setOpaque(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JPanel actionPanel = new JPanel(new BorderLayout());
        actionPanel.add((Component)this.actionLabel, "North");
        actionPanel.add((Component)this.progress, "South");
        this.splashPanel.add((Component)this.splashImage, "North");
        this.splashPanel.add((Component)actionPanel, "South");
        this.actionLabel.setHorizontalAlignment(0);
        this.splashImage.setText(imageText);
        this.actionLabel.setText(labelText);
        this.actionLabel.setPreferredSize(new Dimension(300, 23));
        this.progress.setVisible(false);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setVisible(true);
    }

    public void setProgress(final int max, final int min, final int value, final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (max == min && Splash.this.progress.isVisible()) {
                    Splash.this.progress.setVisible(false);
                    return;
                }
                if (Splash.this.progress.getMaximum() != max) {
                    Splash.this.progress.setMaximum(max);
                }
                if (Splash.this.progress.getMinimum() != min) {
                    Splash.this.progress.setMinimum(min);
                }
                if (Splash.this.progress.getValue() != value) {
                    Splash.this.progress.setValue(value);
                }
                if (!Splash.this.progress.getString().equals(text)) {
                    if (text != null) {
                        Splash.this.progress.setString(text);
                    }
                    if ((text == null || text.length() == 0) && Splash.this.progress.isStringPainted()) {
                        Splash.this.progress.setStringPainted(false);
                    } else if (!Splash.this.progress.isStringPainted()) {
                        Splash.this.progress.setStringPainted(true);
                    }
                }
                if (!Splash.this.progress.isVisible()) {
                    Splash.this.progress.setVisible(true);
                    Splash.this.pack();
                }
            }
        });
    }

    public void setText(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Splash.this.actionLabel.setText(text);
            }
        });
    }
}

