/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jnlp;

import com.elluminate.common.LinuxJDialog;
import com.elluminate.common.ProgressDialog;
import com.elluminate.jnlp.ArchiveInfo;
import com.elluminate.jnlp.CacheArchiveManager;
import com.elluminate.jnlp.CacheFolderDialog;
import com.elluminate.jnlp.SecureUrl;
import com.elluminate.mediastream.MRFile;
import com.elluminate.vcrfile.VCRFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.jdom.Attribute;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNLPData
implements Cloneable {
    public static final boolean DEBUG = System.getProperty("debugjnlp", null) != null;
    private static final String DOCUMENT_MOVED = "The document has moved <a href=\"";
    private static final String PRIVATE_KEY = "PRIVATE";
    private static final String ELM_LAUNCH_KEY = "var LaunchURL = ";
    private static final String JNLP_File_SUFFIX = ".jnlp";
    public static final String MRF_APP_JAR_NAME = "MRFApp.jar";
    public static final String MRF_APP_PREFIX = "MRFApp";
    public static final String MRF_APP_SUFFIX = ".jar";
    private static final String PLAY_ARGUMENT = "-play";
    private static final String SAS_LAUNCH_KEY = "var LaunchURL = ";
    private static final String SAS_NATIVE_LINK_KEY = "Blackboard Collaborate Format";
    private static final String SAS_NATIVE_HREF_KEY = "<a href=\"";
    private static final String VCR_FILE_SUFFIX = ".vcr";
    private ArchiveInfo archiveInfo = new ArchiveInfo();
    private String[] args = new String[0];
    private SAXBuilder builder;
    private ByteArrayOutputStream byteOut = null;
    private CacheArchiveManager cacheManager = null;
    private String codebase = null;
    private DefaultJDOMFactory factory;
    private JFrame frame = null;
    private LinkedList<String> jarList = new LinkedList();
    private Document jdoc;
    private String jnlpPath = "";
    private MRFile mrfFile = null;
    private String mrfPath = null;
    private String playArg = null;
    private Element rootElement = null;
    private boolean stagedVCR = false;
    private VCRFile vcrFile = null;
    private long vcrLength = -1L;
    private String vcrPath = null;
    private InputStream vcrStream = null;

    private JNLPData() {
    }

    public JNLPData(File jnlpFile) throws Exception {
        this.jnlpPath = jnlpFile.getPath();
        this.frame = null;
        this.initializeJDOM(new FileInputStream(jnlpFile), jnlpFile.getPath(), false, jnlpFile);
        this.processLaunch(this.rootElement.getChildren("application-desc"));
    }

    public JNLPData(File jnlpFile, JFrame frame) throws Exception {
        URLConnection.setDefaultAllowUserInteraction(true);
        this.jnlpPath = jnlpFile.getPath();
        this.frame = frame;
        this.initializeJDOM(new FileInputStream(jnlpFile), jnlpFile.getPath(), true, jnlpFile);
    }

    public JNLPData(InputStream stream, String vcrPath, JFrame frame) throws Exception {
        this.frame = frame;
        this.initializeJDOM(stream, vcrPath, true, null);
    }

    public JNLPData(String urlString, JFrame frame) throws Exception {
        this.jnlpPath = urlString;
        this.frame = frame;
        this.processJNLPData(urlString, true);
    }

    public Object clone() {
        JNLPData newJnlpData = null;
        try {
            newJnlpData = (JNLPData)super.clone();
            newJnlpData.jarList = new LinkedList();
            if (!this.isMRF()) {
                newJnlpData.initializeJDOM(this.getByteStream(), this.vcrPath, false, null);
                newJnlpData.codebase = this.codebase;
            }
            newJnlpData.vcrPath = this.vcrPath;
            newJnlpData.mrfFile = this.mrfFile;
            newJnlpData.mrfPath = this.mrfPath;
        }
        catch (Exception ex) {
            return null;
        }
        return newJnlpData;
    }

    public boolean containsJar(String jar) {
        return this.jarList.contains(jar);
    }

    private byte[] fixElmEntities(ByteArrayOutputStream str) throws IOException {
        ByteArrayOutputStream newStr = new ByteArrayOutputStream();
        byte[] bytes = str.toByteArray();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 38) {
                for (int j = i; j < i + 4; ++j) {
                    if (bytes[j] != 59) continue;
                    newStr.write(bytes[i]);
                    break;
                }
                newStr.write(new byte[]{38, 97, 109, 112, 59});
                continue;
            }
            newStr.write(bytes[i]);
        }
        byte[] result = newStr.toByteArray();
        return result;
    }

    public ArchiveInfo getArchiveInfo() {
        return this.archiveInfo;
    }

    public String[] getArgs() {
        return this.args;
    }

    public InputStream getByteStream() {
        if (this.byteOut == null) {
            throw new RuntimeException("Try to get jnlp data before it is read.");
        }
        return new ByteArrayInputStream(this.byteOut.toByteArray());
    }

    public String getCodebase() {
        return this.codebase;
    }

    public int getJNLPLength() {
        return this.byteOut.size();
    }

    public String getJNLPPath() {
        return this.jnlpPath;
    }

    public MRFile getMRFile() {
        return this.mrfFile;
    }

    public String getMRFPath() {
        return this.mrfFile.getPath();
    }

    public Element getRoot() {
        return this.rootElement;
    }

    public VCRFile getVCRFile() {
        return this.vcrFile;
    }

    public long getVCRLength() {
        return this.vcrLength;
    }

    public String getVCRPath() {
        return this.vcrPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getVCRStream() throws Exception {
        URLConnection conn = null;
        LinuxJDialog pane = null;
        if (this.vcrPath == null && this.playArg == null) {
            throw new Exception("JNLP does not reference a VCR file.");
        }
        if (this.frame != null) {
            pane = new LinuxJDialog(this.frame, "Busy Accessing VCR File", false){

                public void setVisible(boolean visible) {
                    if (visible) {
                        this.setDefaultCloseOperation(0);
                        this.add(new JLabel("<html><center>Trying to acces vcr file:<br>" + JNLPData.this.vcrPath + "</center></html>"));
                        this.pack();
                        Rectangle parentRect = super.getParent().getBounds();
                        Point loc = new Point(parentRect.x + (parentRect.width - this.getSize().width) / 2, parentRect.y + (parentRect.height - this.getSize().height) / 2);
                        this.setLocation(loc);
                    }
                    if (visible) {
                        JNLPData.this.frame.setCursor(Cursor.getPredefinedCursor(3));
                    } else {
                        JNLPData.this.frame.setCursor(Cursor.getDefaultCursor());
                    }
                    super.setVisible(visible);
                }
            };
            ((Dialog)pane).setVisible(true);
        }
        InputStream in = null;
        try {
            URL url = this.vcrPath != null ? new URL(this.vcrPath) : new URL(this.playArg);
            try {
                conn = SecureUrl.resolveConnection((URL)url, (JFrame)this.frame);
                this.vcrLength = conn.getContentLength();
                this.validateVCRLength(this.vcrLength);
                in = conn.getInputStream();
            }
            catch (IOException ex1) {
                throw new Exception("Cannot access URL: " + this.vcrPath + "\n" + ex1.getMessage());
            }
        }
        catch (MalformedURLException ex) {
            try {
                File file = new File(this.vcrPath);
                this.stagedVCR = true;
                this.vcrLength = file.length();
                this.validateVCRLength(this.vcrLength);
                in = new FileInputStream(file);
            }
            catch (IOException ioe) {
                throw new Exception("Cannot resolve (URL or file): " + this.vcrPath);
            }
        }
        finally {
            if (pane != null) {
                ((Dialog)pane).setVisible(false);
                pane = null;
            }
        }
        return in == null ? null : new BufferedInputStream(in);
    }

    public URL getVCRUrl() {
        URL url = null;
        if (new File(this.vcrPath).isFile()) {
            try {
                url = new URL("file:///" + this.vcrPath);
            }
            catch (MalformedURLException ex1) {
                // empty catch block
            }
        }
        if (url == null) {
            try {
                url = new URL(this.vcrPath);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public boolean needJNLP(boolean needMRFApp) throws IOException, Exception {
        ArchiveInfo cacheMember;
        if (this.vcrFile == null) {
            this.vcrFile = VCRFile.factory((DataInputStream)new DataInputStream(this.getVCRStream()));
        }
        if (this.jarCount() > 0 && (!needMRFApp || this.jarList.contains(MRF_APP_JAR_NAME))) {
            return true;
        }
        if (this.cacheManager == null) {
            this.cacheManager = new CacheArchiveManager();
            while (!CacheArchiveManager.isInitialized()) {
                if (JNLPData.setCachePath(this.frame, "Version Archive location is unknown.\nPlease enter a pathname:")) continue;
                return false;
            }
        }
        if ((cacheMember = this.cacheManager.getArchive(this.vcrFile, needMRFApp)) == null || cacheMember.getArchiveFile() == null) {
            JOptionPane.showMessageDialog(this.frame, "Cannot find a cached Elluminate Live Version.", "No Cached Version", 2);
            return false;
        }
        ProgressDialog progressDialog = new ProgressDialog(this.frame, "Copying Version Archive", null);
        this.stageArchive(progressDialog, cacheMember, this.cacheManager);
        return true;
    }

    public static boolean setCachePath(JFrame frame, String msg) {
        CacheFolderDialog dialog = new CacheFolderDialog(frame, CacheArchiveManager.getCacheFolderPath(), msg);
        dialog.setVisible(true);
        if (dialog.isCancelled()) {
            return false;
        }
        String path = dialog.getPath();
        if (path == null || path.length() == 0) {
            return false;
        }
        try {
            CacheArchiveManager.initializeCache((String)path);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(frame, "Version Archive location error: " + ex.getMessage(), "Error Specifying Version Archive Folder", 0);
        }
        return true;
    }

    public void setCodebase(String codebase) {
        this.codebase = codebase;
    }

    public void setMRFAppJar(String mrfAppPath) {
        if (this.containsJar(MRF_APP_JAR_NAME)) {
            return;
        }
        this.jarList.add(MRF_APP_JAR_NAME);
        Element element = this.jdoc.getRootElement();
        Element rscElement = new Element("resources");
        Element jarElement = new Element("jar");
        jarElement.setAttribute(new Attribute("href", MRF_APP_JAR_NAME));
        element.addContent(rscElement);
        rscElement.addContent(jarElement);
        try {
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            this.byteOut = new ByteArrayOutputStream();
            fmt.output(this.jdoc, (OutputStream)this.byteOut);
            this.byteOut.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot regenerate JNLP.", ex);
        }
    }

    private void stageArchive(final ProgressDialog progressDialog, final ArchiveInfo cacheMember, final CacheArchiveManager cacheManager) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    File stagedFolder = cacheManager.stageArchive(cacheMember, progressDialog);
                    JNLPData.this.initializeJDOM(new FileInputStream(new File(stagedFolder, "jnlp/jnlp")), JNLPData.this.vcrPath, false, null);
                    JNLPData.this.codebase = "file:///" + stagedFolder.getPath();
                    JNLPData.this.archiveInfo = cacheMember;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        progressDialog.setRunnable(runnable);
        progressDialog.setVisible(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeJDOM(InputStream istr, String vcrPath, boolean codebaseAndLaunch, File vcrFile) throws IOException, JDOMException {
        this.jarList.clear();
        this.byteOut = null;
        this.archiveInfo = new ArchiveInfo();
        PushbackInputStream stream = new PushbackInputStream(istr, 512);
        byte[] magic = new byte[4];
        stream.read(magic);
        stream.unread(magic);
        String magicString = new String(magic);
        if (vcrPath != null && magicString.equals("VCR\u0000")) {
            this.processDirectVCR(vcrPath, stream);
        } else if (vcrPath != null && magic[0] == 80 && magic[1] == 75 && magic[2] == 3 && magic[3] == 4) {
            JarInputStream jarIstr = new JarInputStream((InputStream)stream, true);
            boolean foundVCR = false;
            JarEntry entry = jarIstr.getNextJarEntry();
            while (entry != null) {
                if (entry.getName().endsWith(VCR_FILE_SUFFIX)) {
                    foundVCR = true;
                    this.processUnpluggedVCR(jarIstr, vcrPath, entry.getName());
                    break;
                }
                entry = jarIstr.getNextJarEntry();
            }
            if (!foundVCR) {
                throw new RuntimeException("Could not resolve a vcr file in: " + vcrPath);
            }
        } else if (magicString.equals(new String(MRFile.FOURCC))) {
            this.processMRF(vcrPath, stream, vcrFile);
        } else {
            int strByte = stream.read();
            while (strByte >= 0 && strByte != 60) {
                strByte = stream.read();
            }
            stream.unread(60);
            BufferedInputStream bIn = new BufferedInputStream(stream);
            this.byteOut = new ByteArrayOutputStream();
            byte[] byteBuffer = new byte[Short.MAX_VALUE];
            int read = 0;
            do {
                if ((read = bIn.read(byteBuffer)) <= 0) continue;
                this.byteOut.write(byteBuffer, 0, read);
            } while (read > 0);
            String content = this.byteOut.toString().trim().toLowerCase();
            if (!content.startsWith("<?xml")) {
                if (this.frame == null || !content.startsWith("<html")) throw new IOException("JNLP does not contain XML: " + content);
                HTMLDialog dialog = new HTMLDialog(this.frame, "Trying to read JNLP", true);
                dialog.setHTML(content);
                dialog.setVisible(true);
            } else {
                ByteArrayInputStream byteStream = new ByteArrayInputStream(this.fixElmEntities(this.byteOut));
                this.builder = new SAXBuilder(false);
                this.factory = new DefaultJDOMFactory();
                this.builder.setFactory(this.factory);
                this.jdoc = this.builder.build(byteStream);
                this.rootElement = this.jdoc.getRootElement();
                this.processJDOM(codebaseAndLaunch, codebaseAndLaunch);
            }
        }
        stream.close();
    }

    public boolean isMRF() {
        return this.mrfPath != null;
    }

    public boolean isVCRStaged() {
        return this.stagedVCR;
    }

    public int jarCount() {
        return this.jarList.size();
    }

    public Iterator<String> jarIterator() {
        return this.jarList.iterator();
    }

    private void processDirectVCR(String vcrPath, InputStream is) throws IOException {
        this.vcrPath = vcrPath;
        this.mrfPath = null;
        this.vcrFile = VCRFile.factory((DataInputStream)new DataInputStream(is));
        this.stagedVCR = true;
    }

    private void processElement(Element element) {
        LinkedList<String> osNames = new LinkedList<String>();
        if (element.getName().equals("resources")) {
            String os = element.getAttributeValue("os");
            StringBuffer osName = new StringBuffer();
            boolean sawEscape = false;
            for (int i = 0; os != null && i < os.length(); ++i) {
                if (os.charAt(i) == '\\') {
                    sawEscape = true;
                    continue;
                }
                if (sawEscape || os.charAt(i) != ' ') {
                    osName.append(os.charAt(i));
                    continue;
                }
                osNames.add(osName.toString());
                osName = new StringBuffer();
            }
            if (osName.length() > 0) {
                osNames.add(osName.toString());
            }
        } else if (element.getName().equals("jar") || element.getName().equals("nativelib")) {
            String jarName = element.getAttributeValue("href");
            this.jarList.add(jarName);
        }
        List elements = element.getChildren();
        if (elements.size() > 0) {
            this.processResource(elements);
        }
    }

    private void processHttpURLConnection(URL connectionURL, HttpURLConnection hc) throws JDOMException, MalformedURLException, Exception {
        int code = hc.getResponseCode();
        if (code >= 400) {
            throw new IOException(code + ": " + hc.getResponseMessage());
        }
        if (code == 302) {
            String page = this.readWebPage(hc);
            hc.disconnect();
            int startIndex = page.indexOf(DOCUMENT_MOVED);
            if (startIndex < 0) {
                throw new RuntimeException("Invalid Redirect Page:" + hc.getURL().toString());
            }
            String redirection = page.substring(startIndex + DOCUMENT_MOVED.length());
            int len = redirection.indexOf(VCR_FILE_SUFFIX) + VCR_FILE_SUFFIX.length();
            this.processJNLPData(redirection.substring(0, len), true);
            return;
        }
        String type = hc.getContentType();
        if (type.startsWith("application/octet-stream")) {
            if (hc != null) {
                this.initializeJDOM(hc.getInputStream(), hc.getURL().toString(), true, null);
                hc.disconnect();
            }
            return;
        }
        if (type.startsWith("application/download")) {
            String page = this.readWebPage(hc);
            hc.disconnect();
            int start = page.indexOf("http://");
            if (start < 0) {
                start = page.indexOf("https://");
            }
            String linkURL = page.substring(start);
            int len = linkURL.indexOf("UID:");
            this.processJNLPData(linkURL.substring(0, len), true);
            return;
        }
        if (type != null && type.startsWith("text/html")) {
            String page = this.readWebPage(hc);
            URL url = new URL(this.processWebPage(page, hc.getURL()));
            hc.disconnect();
            URLConnection connection = SecureUrl.resolveConnection((URL)url, (JFrame)this.frame);
            type = connection.getContentType();
            if (type.indexOf("x-java-jnlp-file") < 0) {
                String text = this.readWebPage((HttpURLConnection)connection);
                if (DEBUG) {
                    HTMLDialog dialog = new HTMLDialog(this.frame, "processHttpURLConnection.jnlp", false);
                    dialog.setHTML(text);
                    dialog.setVisible(true);
                }
                if (text.contains("Elluminate Recording Tracking")) {
                    throw new RuntimeException("Recording Viewer Details option has been enabled for this recording.\nEither download the jnlp or vcr file to process manually,\nor disable this feature for this recording in the SAS.");
                }
                if (text.contains("has been deleted")) {
                    throw new RuntimeException("The recording has been deleted.");
                }
                throw new RuntimeException("Not a valid playback link.");
            }
            if (connection instanceof HttpURLConnection && (code = (hc = (HttpURLConnection)connection).getResponseCode()) >= 400) {
                throw new IOException(code + ": " + hc.getResponseMessage());
            }
        } else {
            int semi = type.indexOf(59);
            if (semi > 0) {
                type = type.substring(0, semi);
            }
        }
        this.initializeJDOM(hc.getInputStream(), hc.getURL().toString(), true, null);
        hc.disconnect();
    }

    private void processJDOM(boolean processCodebase, boolean processLaunch) {
        if (processCodebase) {
            this.codebase = this.rootElement.getAttributeValue("codebase");
        }
        this.processResource(this.rootElement.getChildren());
        if (processLaunch) {
            this.processLaunch(this.rootElement.getChildren("application-desc"));
        }
    }

    private void processJNLPData(String urlString, boolean init) throws JDOMException, MalformedURLException, Exception {
        URL url;
        block6: {
            url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException ex) {
                if (!new File(urlString).isFile()) break block6;
                url = new URL("file://" + urlString);
            }
        }
        if (url == null) {
            throw new RuntimeException("Cannot find JNLP: " + urlString);
        }
        if (url.getProtocol().equalsIgnoreCase("file")) {
            this.initializeJDOM(new FileInputStream(URLDecoder.decode(url.getFile(), "UTF-8")), urlString, init, null);
            return;
        }
        URLConnection connection = SecureUrl.resolveConnection((URL)url, (JFrame)this.frame);
        if (!(connection instanceof HttpURLConnection)) {
            File file = new File(URLDecoder.decode(urlString, "UTF-8"));
            if (file.exists()) {
                this.initializeJDOM(new FileInputStream(file), urlString, init, null);
                return;
            }
            throw new RuntimeException("Unknown protocol: " + url.getProtocol());
        }
        this.processHttpURLConnection(connection.getURL(), (HttpURLConnection)connection);
    }

    private void processLaunch(List appDescList) {
        for (Element appElement : appDescList) {
            List argList = appElement.getChildren("argument");
            this.args = new String[argList.size()];
            Iterator iterArg = argList.iterator();
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = ((Element)iterArg.next()).getTextTrim();
            }
        }
        this.playArg = null;
        this.vcrPath = null;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].toLowerCase().endsWith(VCR_FILE_SUFFIX)) {
                this.vcrPath = this.args[i];
                break;
            }
            if (!this.args[i].toLowerCase().equals(PLAY_ARGUMENT)) continue;
            this.vcrPath = this.playArg = this.args[i + 1];
        }
    }

    private void processMRF(String mrfPath, InputStream is, File mrfFile) throws IOException {
        this.mrfPath = mrfPath;
        this.vcrPath = null;
        this.mrfFile = mrfFile != null ? new MRFile(mrfFile) : new MRFile(is);
    }

    private void processResource(List elementList) {
        for (Element element : elementList) {
            this.processElement(element);
        }
    }

    private void processUnpluggedVCR(JarInputStream jarIstr, String vcrPath, String entryName) throws IOException {
        String vcrEntryPath;
        if (new File(vcrPath).isFile()) {
            vcrEntryPath = "jar:file:///" + vcrPath + "!/" + entryName;
        } else {
            try {
                URL url = new URL(vcrPath);
                vcrEntryPath = "jar:" + vcrPath + "!/" + entryName;
            }
            catch (MalformedURLException ex) {
                throw new IOException("Cannot resolve VCR path: " + vcrPath);
            }
        }
        this.processDirectVCR(vcrEntryPath, jarIstr);
        jarIstr.close();
    }

    private String processWebPage(String webPageString, URL oldURL) throws Exception, MalformedURLException {
        URLConnection connection;
        String launchURL;
        boolean suid;
        String urlString = oldURL.toString();
        int prefixLength = urlString.indexOf(oldURL.getFile());
        String prefix = urlString.substring(0, prefixLength);
        int startArgs = urlString.indexOf("?");
        if (startArgs < 0) {
            throw new RuntimeException("No player arguments");
        }
        boolean psid = urlString.indexOf("?psid=") >= 0 || urlString.indexOf("&psid=") >= 0;
        boolean bl = suid = urlString.indexOf("?suid=") >= 0 || urlString.indexOf("&suid=") >= 0;
        if (!suid && !psid) {
            throw new RuntimeException("no Player PSID or recordingId");
        }
        int startIndex = webPageString.indexOf("var LaunchURL = ");
        int nativeLinkIndex = webPageString.indexOf(SAS_NATIVE_LINK_KEY);
        if (startIndex < 0 && nativeLinkIndex < 0) {
            if (webPageString.indexOf(PRIVATE_KEY) >= 0) {
                throw new RuntimeException("Recording is Private.\n");
            }
            throw new RuntimeException("Cannot find LaunchURL from page");
        }
        if (startIndex < 0) {
            startIndex = webPageString.lastIndexOf(SAS_NATIVE_HREF_KEY, nativeLinkIndex) + SAS_NATIVE_HREF_KEY.length();
            int endIndex = webPageString.indexOf("\"", startIndex);
            launchURL = webPageString.substring(startIndex, endIndex) + "?" + urlString.substring(startArgs + 1);
            try {
                new URL(launchURL);
            }
            catch (MalformedURLException ex) {
                launchURL = prefix + launchURL;
            }
            connection = SecureUrl.resolveConnection((URL)new URL(launchURL), (JFrame)this.frame);
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection hc = (HttpURLConnection)connection;
                int code = hc.getResponseCode();
                if (code >= 400) {
                    throw new IOException(code + ": " + hc.getResponseMessage());
                }
                String page = this.readWebPage(hc);
                return this.processWebPage(page, oldURL);
            }
        } else {
            int endIndex = webPageString.indexOf(JNLP_File_SUFFIX, startIndex += "var LaunchURL = ".length() + 1);
            if (suid) {
                if ((endIndex = webPageString.indexOf(VCR_FILE_SUFFIX, endIndex) + VCR_FILE_SUFFIX.length()) < 0) {
                    throw new RuntimeException("Cannot parse JNLP file suffix");
                }
                launchURL = webPageString.substring(startIndex, endIndex);
                connection = SecureUrl.resolveConnection((URL)new URL(urlString), (JFrame)this.frame);
                if (connection instanceof HttpURLConnection) {
                    HttpURLConnection hc = (HttpURLConnection)connection;
                    int code = hc.getResponseCode();
                    if (code >= 400) {
                        throw new IOException(code + ": " + hc.getResponseMessage());
                    }
                    String page = this.readWebPage(hc);
                    try {
                        new URL(launchURL);
                    }
                    catch (MalformedURLException ex) {
                        launchURL = prefix + launchURL;
                    }
                    return this.processWebPage(page, new URL(launchURL));
                }
            } else {
                if ((endIndex += JNLP_File_SUFFIX.length()) < 0) {
                    throw new RuntimeException("Cannot parse JNLP file suffix");
                }
                launchURL = webPageString.substring(startIndex, endIndex) + "?" + urlString.substring(startArgs + 1);
            }
        }
        try {
            URL url = new URL(launchURL);
        }
        catch (MalformedURLException ex) {
            launchURL = prefix + launchURL;
        }
        return launchURL;
    }

    private String readWebPage(HttpURLConnection hc) {
        StringBuffer buf = new StringBuffer();
        try {
            if (hc != null) {
                int read;
                InputStream inStream = hc.getInputStream();
                byte[] buffer = new byte[32768];
                do {
                    if ((read = inStream.read(buffer)) <= 0) continue;
                    buf.append(new String(buffer, 0, read));
                } while (read > 0);
                inStream.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException(ioe.getMessage());
        }
        String result = buf.toString();
        if (DEBUG) {
            HTMLDialog dialog = new HTMLDialog(this.frame, "readWebPage.", false);
            dialog.setHTML(result);
            dialog.setVisible(true);
        }
        return result;
    }

    public void setVCRFile(VCRFile vcrFile) {
        this.vcrFile = vcrFile;
    }

    public void stageVCRFile(ProgressDialog progressDialog) throws Exception {
        if (this.stagedVCR) {
            return;
        }
        File newVCR = File.createTempFile("staged.", VCR_FILE_SUFFIX);
        FileOutputStream fos = new FileOutputStream(newVCR);
        byte[] buf = new byte[65536];
        int read = 0;
        InputStream is = this.getVCRStream();
        int offset = 0;
        do {
            read = is.read(buf);
            if (progressDialog != null) {
                progressDialog.showProgress((int)this.vcrLength, 0, offset, null);
            }
            if (read <= 0) continue;
            fos.write(buf, 0, read);
            offset += read;
        } while (read >= 0 && !progressDialog.wasCancelled());
        fos.close();
        is.close();
        newVCR.deleteOnExit();
        boolean bl = this.stagedVCR = !progressDialog.wasCancelled();
        if (this.stagedVCR) {
            this.vcrPath = "file:///" + newVCR.getPath();
        }
    }

    private void validateVCRLength(long vcrFileLength) throws Exception {
        if (this.vcrLength < 20L) {
            if (this.vcrLength <= 0L) {
                throw new Exception("VCR file is empty.");
            }
            throw new Exception("VCR file is invalid.");
        }
    }

    class HTMLDialog
    extends JDialog {
        JScrollPane pageScroller;
        JTextPane htmlPane;
        HTMLEditorKit editorKit;
        HTMLDocument document;

        public HTMLDialog(JFrame frame, String title, boolean modal) {
            super(frame, title, modal);
            this.htmlPane = new JTextPane();
            this.editorKit = new HTMLEditorKit();
            this.document = new HTMLDocument();
            this.htmlPane.setEditorKit(this.editorKit);
            this.htmlPane.setDocument(this.document);
            this.pageScroller = new JScrollPane(this.htmlPane, 20, 30);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.pageScroller, "Center");
            this.setSize(400, 400);
        }

        public void setVisible(final boolean visible) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.validate();
                super.setVisible(visible);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            HTMLDialog.this.validate();
                            HTMLDialog.super.setVisible(visible);
                        }
                    });
                }
                catch (InvocationTargetException ex) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void setHTML(final String html) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StringBuffer buf = new StringBuffer(html);
                    int htmlStart = buf.indexOf("<html>");
                    buf.insert(htmlStart + 6, "<b></b>");
                    String text = buf.toString();
                    HTMLDialog.this.htmlPane.setText(text);
                    HTMLDialog.this.htmlPane.repaint();
                }
            });
        }
    }
}

