/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.builders.recordingbuilder;

import com.elluminate.builders.Splash;
import com.elluminate.common.Utility;
import com.elluminate.jnlp.JNLPData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnpluggedBootstrap {
    private static final int UNRESOLVED_DISPLAY_TIME = 15;
    private static final String RESTART_KEY = "-restart";
    private static final String TEMP_FOLDER = "-temp-folder";
    private static final String JAVA_EXE = "javaw";
    private static final String JAVA_EXE2 = "java";
    public static final String JNLP_PATH = "jnlp/jnlp";
    private static final boolean USE_VCR_URL = true;
    public static final String VCR_PATH = "vcr.vcr";
    private static final int SPLASH_DELAY = 6000;
    private String[] appArgs = null;
    private String classPath = null;
    private String initialHeapSize = "-Xms32M";
    private HashSet<String> jarSet = new HashSet();
    private JNLPData jnlp = null;
    private String jre;
    private String mainEntry = "";
    private int majorVersion = 0;
    private long maxHeapSizeDefault = 0x6000000L;
    private String maximumHeapSize = "-Xmx96M";
    private int minorVersion = 0;
    private HashSet<String> nativeLibSet = new HashSet();
    private String osVersion;
    private String osArch;
    private ArrayList<String> propertyName = new ArrayList();
    private ArrayList<String> propertyValue = new ArrayList();
    private Splash splash;
    private File tempFolder;
    private ArrayList<UnresolvedJar> unresolvedResourcesList = new ArrayList();
    private ArrayList<UnresolvedJar> unresolvedNativeResourcesList = new ArrayList();
    private URL vcrUrl = null;
    private String version;
    private String vmArgs = "";
    private String title = "Elluminate Live!";
    private Map<String, List<String>> params = new HashMap<String, List<String>>();

    public UnpluggedBootstrap(String[] args) {
        if (args != null && args.length > 0) {
            this.processParams(args);
        }
        this.initialize();
        if (this.params.containsKey(RESTART_KEY)) {
            this.params.remove(RESTART_KEY);
            this.launch();
        } else {
            this.launchRestart();
        }
    }

    private void processParams(String[] args) {
        String flag = null;
        for (String arg : args) {
            if (arg.startsWith("-")) {
                flag = arg;
                this.params.put(arg, new ArrayList());
                continue;
            }
            if (flag != null) {
                this.params.get(flag).add(arg);
                continue;
            }
            System.out.println("Unable to process argument");
        }
        if (Utility.isVerbose()) {
            System.out.println("Process params: ");
            for (String key : this.params.keySet()) {
                System.out.println("Key: " + key);
                for (String val : this.params.get(key)) {
                    System.out.println("\tval: " + val);
                }
            }
        }
    }

    public UnpluggedBootstrap() {
        this(new String[0]);
    }

    private void initialize() {
        this.setupSplashPage();
        this.doJnlpCheck();
        this.setupTempFolder();
        this.buildVMArgs();
        if (Utility.isVerbose()) {
            System.err.println("UnpluggedBootStrap: osVersion: " + this.osVersion + ", arch: " + this.osArch + ", jre: " + this.jre + ", version: " + this.version + ", tempFolder: " + this.tempFolder.getPath() + ", majorVersion: " + this.majorVersion + ", minorVersion: " + this.minorVersion);
        }
        this.splash.setProgress(1, 0, 0, "Processing JNLP Data");
        this.processElement(this.jnlp.getRoot());
    }

    private void launchRestart() {
        try {
            this.createFileset();
            this.execute();
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
            JOptionPane.showMessageDialog(this.splash, "Error in Startup:\n" + ex1.getMessage(), "Cannot Start Player", 0);
            System.exit(-1);
        }
    }

    private void launch() {
        ArrayList<String> args = new ArrayList<String>();
        for (String key : this.params.keySet()) {
            args.add(key);
            List<String> values = this.params.get(key);
            for (String value : values) {
                args.add(value);
            }
        }
        if (Utility.isVerbose()) {
            System.out.println("main class..." + this.mainEntry);
            System.out.println("args: ");
            for (String arg : args) {
                System.out.println("\t" + arg);
            }
        }
        try {
            Class<?> cls = Class.forName(this.mainEntry);
            Method main = cls.getMethod("main", String[].class);
            String[] params = args.toArray(new String[0]);
            main.invoke(null, new Object[]{params});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                UnpluggedBootstrap.this.recursiveDelete(UnpluggedBootstrap.this.tempFolder);
            }
        });
    }

    private void buildVMArgs() {
        long heapMax = Runtime.getRuntime().maxMemory();
        if (heapMax < Long.MAX_VALUE && heapMax > this.maxHeapSizeDefault) {
            this.maximumHeapSize = "-Xmx" + heapMax / 0x100000L + "M";
        }
        this.osVersion = System.getProperty("os.name", "unknown");
        this.osArch = System.getProperty("os.arch", "unknown");
        this.jre = System.getProperty("java.home", "unknown");
        this.version = System.getProperty("java.version", "unknown");
        String[] versionParts = this.version.split("\\.");
        this.majorVersion = Integer.parseInt(versionParts[0]);
        this.minorVersion = Integer.parseInt(versionParts[1]);
    }

    private void setupTempFolder() {
        List<String> folders;
        if (this.params.containsKey(TEMP_FOLDER) && (folders = this.params.get(TEMP_FOLDER)) != null && folders.size() == 1) {
            this.tempFolder = new File(folders.get(0));
            this.params.remove(TEMP_FOLDER);
            return;
        }
        String tempPath = System.getProperty("java.io.tmpdir");
        if (tempPath == null || tempPath.length() == 0) {
            throw new RuntimeException("Cannot determine the temporary folder.");
        }
        this.tempFolder = new File(tempPath, Long.toHexString(System.currentTimeMillis()));
        this.tempFolder.mkdir();
    }

    private void doJnlpCheck() {
        try {
            this.jnlp = new JNLPData(UnpluggedBootstrap.class.getResourceAsStream("/jnlp/jnlp"), null, null);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Cannot get embedded JNLP file: jnlp/jnlp\n" + ex.getMessage(), "Cannot Play Recording", 0);
            System.exit(1);
        }
    }

    private void setupSplashPage() {
        this.splash = new Splash("Blackboard Collaborate Unplugged Recording", "<html><c>Blackboard Collaborate<br>Unplugged Playback<br>Version 1.1</c></html>", "Initializing Player", null);
    }

    private void recursiveDelete(File folder) {
        if (folder == null || !folder.exists()) {
            return;
        }
        if (folder.isDirectory()) {
            File[] children = folder.listFiles();
            for (int i = children.length - 1; i >= 0; --i) {
                try {
                    if (children[i].isDirectory()) {
                        this.recursiveDelete(children[i]);
                        continue;
                    }
                    if (Utility.isVerbose()) {
                        System.out.println("DELETE: " + children[i]);
                    }
                    children[i].delete();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (Utility.isVerbose()) {
            System.out.println("DELETE: " + folder);
        }
        folder.delete();
    }

    private void processElement(Element element) {
        if (Utility.isVerbose()) {
            System.err.println("processElement: " + element.getName());
        }
        if (element.getName().equals("j2se") || element.getName().equals(JAVA_EXE2)) {
            this.processJ2se(element);
        } else if (element.getName().equals("property")) {
            this.processProperty(element);
        }
        if (element.getName().equals("resources")) {
            this.processResources(element);
        } else if (element.getName().equals("jnlp")) {
            this.processJNLPElement(element);
        } else if (element.getName().equals("information")) {
            this.processInformation(element);
        } else if (element.getName().equals("title")) {
            this.processTitle(element);
        } else if (element.getName().equals("application-desc")) {
            this.processAppDesc(element);
        } else if (element.getName().equals("jar")) {
            this.processJar(element);
        } else if (element.getName().equals("nativelib")) {
            this.processNativeLib(element);
        } else {
            this.processChildren(element);
        }
    }

    private void processChildren(Element element) {
        if (Utility.isVerbose()) {
            System.err.println("processChildren, Element: " + element.getName());
        }
        Iterator iter = element.getChildren().iterator();
        while (iter.hasNext()) {
            this.processElement((Element)iter.next());
        }
    }

    private void processJ2se(Element element) {
        String maxHeapSize;
        String initHeapSize;
        String version = element.getAttributeValue("version");
        this.vmArgs = element.getAttributeValue("java-vm-args");
        String[] split = version.split("\\.");
        int major = Integer.parseInt(split[0]);
        int plus = split[1].indexOf(43);
        if (plus >= 0) {
            split[1] = split[1].substring(0, plus);
        }
        int minor = Integer.parseInt(split[1]);
        if (Utility.isVerbose()) {
            System.err.println("processJ2se, version: " + version + ", vmArgs: " + this.vmArgs + ", major: " + major + ", minor: " + minor + ", plus: " + plus + ", split: " + split.length);
            System.err.println("processJ2se, initial-heap-size: " + element.getAttributeValue("initial-heap-size") + ", max-heap-size: " + element.getAttributeValue("max-heap-size") + ", maximum-heap-size: " + element.getAttributeValue("maximum-heap-size"));
        }
        if ((initHeapSize = element.getAttributeValue("initial-heap-size")) != null && initHeapSize.length() > 0) {
            this.initialHeapSize = "-Xms" + initHeapSize;
        }
        if ((maxHeapSize = element.getAttributeValue("max-heap-size")) == null) {
            maxHeapSize = element.getAttributeValue("maximum-heap-size");
        }
        if (maxHeapSize != null && maxHeapSize.length() > 0) {
            this.maximumHeapSize = "-Xmx" + maxHeapSize;
        }
        if (plus >= 0) {
            if (this.majorVersion == major && this.minorVersion >= minor || this.majorVersion > major) {
                this.processChildren(element);
            }
        } else if (split.length > 2 && split[2].indexOf("*") >= 0 && this.majorVersion == major && this.minorVersion == minor) {
            this.processChildren(element);
        }
    }

    private void processProperty(Element element) {
        this.propertyName.add(element.getAttributeValue("name"));
        this.propertyValue.add(element.getAttributeValue("value"));
    }

    private void processResources(Element element) {
        String os = element.getAttributeValue("os");
        HashSet<String> osNames = UnpluggedBootstrap.parseSpaceDelimitedString(os);
        if (Utility.isVerbose()) {
            System.err.println("processResources, os: " + os + ", osNames: " + osNames.size());
        }
        String arch = element.getAttributeValue("arch");
        HashSet<String> archNames = UnpluggedBootstrap.parseSpaceDelimitedString(arch);
        if (Utility.isVerbose()) {
            System.err.println("processResources, arch: " + arch + ", archNames: " + archNames.size());
        }
        if (osNames.size() == 0 && archNames.size() == 0) {
            this.processChildren(element);
        } else {
            boolean osgood = os == null;
            boolean archgood = arch == null;
            for (String name : osNames) {
                if (Utility.isVerbose()) {
                    System.err.println("processResources, osVersion: " + this.osVersion + ", name: " + name);
                }
                if (!this.osVersion.startsWith(name)) continue;
                osgood = true;
                break;
            }
            for (String name : archNames) {
                if (Utility.isVerbose()) {
                    System.err.println("processResources, osVersion: " + this.osVersion + ", arch: " + name);
                }
                if (!this.osArch.equals(name)) continue;
                archgood = true;
                break;
            }
            if (osgood && archgood) {
                this.processChildren(element);
            }
        }
    }

    private void processJNLPElement(Element element) {
        String spec = element.getAttributeValue("spec");
        String codebase = element.getAttributeValue("codebase");
        if (Utility.isVerbose()) {
            System.err.println("processJNLPElement, spec: " + spec + ", codebase: " + codebase);
        }
        this.processChildren(element);
    }

    private void processInformation(Element element) {
        this.processChildren(element);
    }

    private void processAppDesc(Element element) {
        List argsList;
        this.mainEntry = element.getAttributeValue("main-class");
        if (this.mainEntry == null || this.mainEntry.length() == 0) {
            this.mainEntry = "";
        }
        if ((argsList = element.getChildren("argument")) != null) {
            this.appArgs = new String[argsList.size()];
            Iterator iter = argsList.iterator();
            int i = 0;
            while (iter.hasNext()) {
                this.appArgs[i] = ((Element)iter.next()).getTextTrim();
                ++i;
            }
        } else {
            this.appArgs = new String[0];
        }
        if (Utility.isVerbose()) {
            System.err.println("processAppDesc, mainEntry: " + this.mainEntry);
            for (int i = 0; i < this.appArgs.length; ++i) {
                System.err.println("     " + this.appArgs[i]);
            }
        }
    }

    private void processJar(Element element) {
        String jar = element.getAttributeValue("href");
        if (Utility.isVerbose()) {
            System.err.println("processJar: " + jar);
        }
        this.jarSet.add(jar);
    }

    private void processTitle(Element element) {
        String text = element.getText();
        if (text != null && !text.equals("")) {
            this.title = text;
        }
    }

    private void processNativeLib(Element element) {
        String nativeLib = element.getAttributeValue("href");
        if (Utility.isVerbose()) {
            System.err.println("processNativeLib: " + nativeLib);
        }
        this.nativeLibSet.add(element.getAttributeValue("href"));
    }

    private static HashSet<String> parseSpaceDelimitedString(String string) {
        HashSet<String> tokens = new HashSet<String>();
        StringBuffer tok = new StringBuffer();
        boolean sawEscape = false;
        for (int i = 0; string != null && i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch == '\\') {
                sawEscape = true;
                continue;
            }
            if (sawEscape || ch != ' ') {
                tok.append(ch);
                continue;
            }
            tokens.add(tok.toString());
            tok = new StringBuffer();
        }
        if (tok.length() > 0) {
            tokens.add(tok.toString());
        }
        return tokens;
    }

    private void postUnresolvedResourcesDialog() {
        if (this.unresolvedNativeResourcesList.isEmpty() && this.unresolvedResourcesList.isEmpty()) {
            return;
        }
        new UnresolvedDialog(this.splash).setVisible(true);
    }

    private void execute() {
        int i;
        ArrayList<String> argList = new ArrayList<String>();
        File java = new File(this.jre + File.separator + "bin" + File.separator + JAVA_EXE);
        if (!java.exists()) {
            java = new File(this.jre + File.separator + "bin" + File.separator + JAVA_EXE2);
        }
        argList.add(java.getPath());
        argList.add(this.initialHeapSize);
        argList.add(this.maximumHeapSize);
        argList.add("-Djava.library.path=" + this.tempFolder.getPath());
        argList.add("-classpath");
        String currentJar = this.getCurrentJar();
        if (currentJar == null) {
            argList.add(this.classPath.toString());
        } else {
            argList.add(this.classPath.toString() + File.pathSeparator + currentJar);
        }
        if (System.getProperty("os.name").equals("Mac OS X")) {
            argList.add("-Xdock:name=" + this.title);
        }
        for (int i2 = 0; i2 < this.propertyName.size(); ++i2) {
            argList.add("-D" + this.propertyName.get(i2) + "=" + this.propertyValue.get(i2));
        }
        if (this.vmArgs != null && this.vmArgs.length() > 0) {
            String[] vmSplit = this.vmArgs.split(" ");
            for (i = 0; i < vmSplit.length; ++i) {
                argList.add(vmSplit[i]);
            }
        }
        argList.add(this.getClass().getName());
        argList.add(RESTART_KEY);
        argList.add(TEMP_FOLDER);
        try {
            argList.add(this.tempFolder.getAbsolutePath());
        }
        catch (Exception e) {
            argList.add("filenotfound");
        }
        for (int i3 = 0; i3 < this.appArgs.length; ++i3) {
            if (this.appArgs[i3].toLowerCase().equals("-play")) {
                argList.add(this.appArgs[i3++]);
                if (this.vcrUrl != null) {
                    argList.add(this.vcrUrl.toExternalForm());
                    continue;
                }
                argList.add("file:///" + new File(this.tempFolder, VCR_PATH).getPath());
                continue;
            }
            argList.add(this.appArgs[i3]);
        }
        String[] commandArgs = new String[argList.size()];
        for (i = 0; i < argList.size(); ++i) {
            commandArgs[i] = (String)argList.get(i);
        }
        System.err.print("execute:");
        for (i = 0; i < commandArgs.length; ++i) {
            System.err.print(" " + commandArgs[i]);
        }
        System.err.println();
        Utility.healEnvironmentBugs();
        Process app = null;
        try {
            app = Runtime.getRuntime().exec(commandArgs, null, this.tempFolder);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        UnpluggedBootstrap.this.splash.setVisible(false);
                        UnpluggedBootstrap.this.splash.dispose();
                    }
                });
            }
        }, 6000L);
        if (app != null) {
            MoveOutputStreams err = new MoveOutputStreams(app.getErrorStream(), System.err);
            MoveOutputStreams in = new MoveOutputStreams(app.getInputStream(), System.out);
            err.start();
            in.start();
            try {
                err.join();
            }
            catch (InterruptedException ex1) {
                // empty catch block
            }
            try {
                in.join();
            }
            catch (InterruptedException ex2) {
                // empty catch block
            }
        }
    }

    private String getCurrentJar() {
        try {
            File currentJar = new File(UnpluggedBootstrap.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (currentJar.getName().endsWith(".jar")) {
                return currentJar.getPath();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void createFileset() throws IOException {
        StringBuffer classes = new StringBuffer();
        int max = this.jarSet.size() + this.nativeLibSet.size() + 1;
        int count = 0;
        for (String jarName : this.jarSet) {
            this.splash.setProgress(max, 0, count++, "Copying Resource to local system - " + jarName);
            this.moveResource(jarName, classes);
        }
        for (String nativeName : this.nativeLibSet) {
            this.splash.setProgress(max, 0, count++, "Copying Native Library to local system - " + nativeName);
            this.moveNativeResource(nativeName, null);
        }
        this.classPath = classes.toString();
        this.postUnresolvedResourcesDialog();
        this.vcrUrl = UnpluggedBootstrap.class.getResource("/vcr.vcr");
        if (this.vcrUrl == null) {
            this.splash.setProgress(max, 0, count++, "Copying VCR File to local system");
            this.moveResource(VCR_PATH, null);
        }
        this.splash.setProgress(max, 0, count++, "Starting Player");
    }

    private void moveResource(String name, StringBuffer classPath) {
        try {
            URL resourceURL = UnpluggedBootstrap.class.getResource("/" + name);
            BufferedInputStream istr = new BufferedInputStream(resourceURL.openStream());
            File outputFile = new File(this.tempFolder, name);
            outputFile.getParentFile().mkdirs();
            if (Utility.isVerbose()) {
                System.err.println("moveResource: " + resourceURL);
            }
            BufferedOutputStream ostr = new BufferedOutputStream(new FileOutputStream(outputFile));
            int read = 0;
            byte[] buffer = new byte[100000];
            while (read >= 0) {
                read = ((InputStream)istr).read(buffer);
                if (read <= 0) continue;
                ((OutputStream)ostr).write(buffer, 0, read);
            }
            ((InputStream)istr).close();
            ((OutputStream)ostr).close();
            if (classPath != null) {
                if (classPath.length() > 0) {
                    classPath.append(File.pathSeparator);
                }
                classPath.append(outputFile.getPath());
            }
        }
        catch (Exception ex) {
            this.unresolvedResourcesList.add(new UnresolvedJar(name, "", ex.getMessage()));
        }
    }

    private void moveNativeResource(String name, StringBuffer classPath) {
        ZipEntry entry = null;
        try {
            URL resourceURL = UnpluggedBootstrap.class.getResource("/" + name);
            BufferedInputStream istr = new BufferedInputStream(resourceURL.openStream());
            JarInputStream jIstr = new JarInputStream(istr);
            if (Utility.isVerbose()) {
                System.err.println("moveNativeResource: " + resourceURL);
            }
            do {
                if ((entry = jIstr.getNextJarEntry()) == null || entry.getName().indexOf("/") >= 0) continue;
                try {
                    File outputFile = new File(this.tempFolder, entry.getName());
                    if (Utility.isVerbose()) {
                        System.err.println("     output: " + outputFile.getPath());
                    }
                    BufferedOutputStream ostr = new BufferedOutputStream(new FileOutputStream(outputFile));
                    int read = 0;
                    byte[] buffer = new byte[100000];
                    while (read >= 0) {
                        read = jIstr.read(buffer);
                        if (read <= 0) continue;
                        ((OutputStream)ostr).write(buffer, 0, read);
                    }
                    ((OutputStream)ostr).close();
                    if (classPath == null) continue;
                    if (classPath.length() > 0) {
                        classPath.append(File.pathSeparator);
                    }
                    classPath.append(outputFile.getPath());
                }
                catch (Exception e) {
                    // empty catch block
                }
            } while (entry != null);
            jIstr.close();
        }
        catch (Exception ex) {
            if (entry == null) {
                this.unresolvedResourcesList.add(new UnresolvedJar(name, "", ex.getMessage()));
            }
            this.unresolvedResourcesList.add(new UnresolvedJar(name, entry.getName(), ex.getMessage()));
        }
    }

    public static void main(String[] args) {
        UnpluggedBootstrap bootstrap = null;
        bootstrap = args != null && args.length > 0 ? new UnpluggedBootstrap(args) : new UnpluggedBootstrap();
    }

    static {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class UnresolvedJar {
        String name;
        String entry;
        String error;

        public UnresolvedJar(String name, String entry, String error) {
            this.name = name;
            this.entry = entry;
            this.error = error;
        }

        public String getHtml() {
            StringBuffer str = new StringBuffer();
            str.append("<li>");
            str.append(this.name);
            str.append("<br>");
            if (this.entry != null && this.entry.length() > 0) {
                str.append(this.entry);
                str.append("<br>");
            }
            if (this.error != null && this.error.length() > 0) {
                str.append(this.error);
                str.append("</li>");
            }
            return str.toString();
        }
    }

    class UnresolvedDialog
    extends JDialog {
        private JButton closeButton;
        private JLabel closeLabel;
        private JPanel closePanel;
        private JTextPane display;
        private JLabel header;
        private JScrollPane scroller;

        public UnresolvedDialog(JFrame parent) {
            super(parent, "Unresolved Resources", true);
            this.closeButton = new JButton("<html><i>Close Now</i>");
            this.closeLabel = new JLabel();
            this.closePanel = new JPanel(new BorderLayout());
            this.display = new JTextPane();
            this.header = new JLabel();
            this.display.setContentType("text/html");
            this.display.setEditable(false);
            this.scroller = new JScrollPane(this.display, 20, 30);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.header, "North");
            this.getContentPane().add((Component)this.scroller, "Center");
            this.getContentPane().add((Component)this.closePanel, "South");
            this.closePanel.add((Component)this.closeButton, "East");
            this.closePanel.add((Component)this.closeLabel, "West");
            this.header.setHorizontalAlignment(0);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UnresolvedDialog.this.setVisible(false);
                }
            });
            this.setSize(600, 550);
            Rectangle splashRect = parent.getBounds();
            Point location = splashRect.getLocation();
            location.x += (splashRect.width - this.getWidth()) / 2;
            location.y += (splashRect.height - this.getHeight()) / 2;
            this.setLocation(location);
        }

        public void setVisible(boolean visible) {
            if (visible) {
                int i;
                this.header.setText("<html><center><h3>The following resources cannot be found.<br>The recording may not be playable.</h3>");
                StringBuffer b = new StringBuffer();
                b.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n");
                b.append("<html>\n");
                b.append("<head>Cannot Find Resources</head>\n");
                b.append("<body>\n");
                if (!UnpluggedBootstrap.this.unresolvedResourcesList.isEmpty()) {
                    b.append("<h3>Stated Resources</h3>");
                    for (i = 0; i < UnpluggedBootstrap.this.unresolvedResourcesList.size(); ++i) {
                        b.append(((UnresolvedJar)UnpluggedBootstrap.this.unresolvedResourcesList.get(i)).getHtml());
                    }
                }
                if (!UnpluggedBootstrap.this.unresolvedNativeResourcesList.isEmpty()) {
                    b.append("<h3>Native Libraries</h2>");
                    for (i = 0; i < UnpluggedBootstrap.this.unresolvedNativeResourcesList.size(); ++i) {
                        b.append(((UnresolvedJar)UnpluggedBootstrap.this.unresolvedNativeResourcesList.get(i)).getHtml());
                    }
                }
                b.append("</body>\n</html>\n");
                this.display.setText(b.toString());
                Timer timer = new Timer("Unresolved Dialog Timer", true);
                timer.schedule(new TimerTask(){
                    private int secs = 15;

                    public void run() {
                        if (this.secs > 0) {
                            UnresolvedDialog.this.closeLabel.setText("<html><center><i>This dialog will automatically close in " + this.secs + " seconds.</i></center><br>");
                        } else {
                            UnresolvedDialog.this.setVisible(false);
                        }
                        --this.secs;
                    }
                }, 0L, 1000L);
            }
            super.setVisible(visible);
        }
    }

    class MoveOutputStreams
    extends Thread {
        private InputStream istr;
        private PrintStream pipe;

        public MoveOutputStreams(InputStream istr, PrintStream pipe) {
            this.istr = istr;
            this.pipe = pipe;
            this.setDaemon(true);
            this.setPriority(5);
        }

        public void run() {
            int read = 0;
            byte[] buffer = new byte[1000];
            while (read >= 0) {
                try {
                    read = this.istr.read(buffer);
                    if (read <= 0) continue;
                    this.pipe.print(new String(buffer, 0, read));
                }
                catch (IOException ex1) {
                    ex1.printStackTrace();
                    read = -1;
                }
            }
        }
    }
}

